/*
 * Decompiled with CFR 0.152.
 */
package ca.bkaw.papernmsmavenplugin;

import ca.bkaw.papernmsmavenplugin.MojoBase;
import ca.bkaw.papernmsmavenplugin.RemappedClasses;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.TinyUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="remap", defaultPhase=LifecyclePhase.PACKAGE)
public class RemapMojo
extends MojoBase {
    private RemappedClasses remappedClasses;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean hasMojangMappings;
        this.createDevBundleConfiguration();
        Path inputPath = this.project.getArtifact().getFile().toPath();
        String gameVersion = this.getGameVersion();
        Path cacheDirectory = this.getCacheDirectory();
        Path mappingsPath = cacheDirectory.resolve("mappings_" + gameVersion + ".tiny");
        Path mappingsMojangPath = cacheDirectory.resolve("mappings_" + gameVersion + "_mojang.tiny");
        Path mappingsSpigotPath = cacheDirectory.resolve("mappings_" + gameVersion + "_spigot.tiny");
        if (Files.exists(mappingsMojangPath, new LinkOption[0]) != Files.exists(mappingsSpigotPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Broken mappings found, running init");
            try {
                Files.deleteIfExists(mappingsPath);
                Files.deleteIfExists(mappingsMojangPath);
                Files.deleteIfExists(mappingsSpigotPath);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Unable to delete mappings", (Exception)exception);
            }
            this.init();
        }
        String mappingFrom = "mojang";
        String mappingTo = "spigot";
        ArrayList<Path> classPath = new ArrayList<Path>();
        for (Object object : this.project.getDependencies()) {
            Dependency dependency = (Dependency)object;
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
            try {
                this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            }
            catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Failed to resolve " + artifact.getGroupId() + ":" + artifact.getArtifactId()), e);
                continue;
            }
            classPath.add(artifact.getFile().toPath());
        }
        if (!Files.exists(mappingsPath, new LinkOption[0]) && !Files.exists(mappingsMojangPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"No mappings found, running init");
            this.init();
        }
        if (!(hasMojangMappings = Files.exists(mappingsMojangPath, new LinkOption[0]))) {
            try {
                BufferedReader bufferedReader = Files.newBufferedReader(mappingsPath);
                String line = bufferedReader.readLine();
                bufferedReader.close();
                if (line.contains("mojang+yarn")) {
                    mappingFrom = "mojang+yarn";
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to check the mappings namespace.", (Exception)e);
            }
        }
        PrintStream normalOut = System.out;
        System.setOut(new PrintStream(normalOut){
            private int count;

            @Override
            public PrintStream printf(String format, Object ... args) {
                if (format.contains(" -> ")) {
                    ++this.count;
                    return this;
                }
                return super.printf(format, args);
            }

            @Override
            public void println(String x) {
                if (x.contains("fixable: replaced with")) {
                    ++this.count;
                    return;
                }
                if (x.contains("%count%")) {
                    if (this.count <= 0) {
                        return;
                    }
                    x = x.replace("%count%", String.valueOf(this.count));
                }
                super.println(x);
            }
        });
        if (hasMojangMappings) {
            this.remapDouble(inputPath, mappingsMojangPath, mappingsSpigotPath, classPath);
        } else if (Files.isDirectory(inputPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Remapping classes");
            this.remapClasses(inputPath, mappingsPath, mappingFrom, mappingTo, classPath, true);
        } else {
            Path outputPath = cacheDirectory.resolve("remapped.jar");
            this.getLog().info((CharSequence)"Remapping artifact");
            this.remapArtifact(inputPath, outputPath, mappingsPath, mappingFrom, mappingTo, classPath);
        }
        System.out.println("/ %count% suppressed lines /");
        System.setOut(normalOut);
        if (this.remappedClasses != null) {
            try {
                this.remappedClasses.save();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to save remapped classes json.", (Exception)e);
            }
        }
    }

    public void remapClasses(Path classesPath, Path mappingsPath, String mappingFrom, String mappingTo, List<Path> classPath, boolean markRemapping) throws MojoExecutionException {
        if (this.remappedClasses == null) {
            try {
                this.remappedClasses = new RemappedClasses(this.getCacheDirectory().resolve("classes.json"), classesPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read remapped classes json.", (Exception)e);
            }
        }
        IMappingProvider mappings = TinyUtils.createTinyMappingProvider((Path)mappingsPath, (String)mappingFrom, (String)mappingTo);
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappings).ignoreConflicts(true).build();
        remapper.readClassPath(classPath.toArray(new Path[0]));
        remapper.readInputs(new Path[]{classesPath});
        remapper.apply((name, bytes) -> {
            try {
                Path path = classesPath.resolve(name + ".class");
                if (!this.remappedClasses.isAlreadyRemapped(path)) {
                    Files.write(path, bytes, new OpenOption[0]);
                    if (markRemapping) {
                        this.remappedClasses.markAsRemappedNow(path);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write class " + name, e);
            }
        });
        remapper.finish();
    }

    public void remapArtifact(Path artifactPath, Path outputPath, Path mappingsPath, String mappingFrom, String mappingTo, List<Path> classPath) throws MojoExecutionException {
        try {
            Files.deleteIfExists(outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException " + e.getMessage(), (Exception)e);
        }
        try {
            this.mapJar(artifactPath, outputPath, mappingsPath, mappingFrom, mappingTo, classPath.toArray(new Path[0]));
        }
        catch (IOException | URISyntaxException e) {
            throw new MojoExecutionException("Failed to remap artifact", e);
        }
        this.getLog().info((CharSequence)"Replacing artifact.");
        try {
            Files.delete(artifactPath);
            Files.move(outputPath, artifactPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to replace artifact with the remapped artifact.", (Exception)e);
        }
    }

    public void remapDouble(Path artifactPath, Path mappingsMojangPath, Path mappingsSpigotPath, List<Path> classPath) throws MojoExecutionException {
        if (Files.isDirectory(artifactPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Remapping classes to obfuscated form");
            this.remapClasses(artifactPath, mappingsMojangPath, "mojang", "obfuscated", classPath, false);
        } else {
            Path outputPath = this.getCacheDirectory().resolve("remapped.jar");
            this.getLog().info((CharSequence)"Remapping artifact to obfuscated form");
            this.remapArtifact(artifactPath, outputPath, mappingsMojangPath, "mojang", "obfuscated", classPath);
        }
        this.getLog().info((CharSequence)"Remapping dependencies to obfuscated form");
        ArrayList<Path> newClassPath = new ArrayList<Path>(classPath.size());
        int count = 0;
        for (Path path : classPath) {
            ArrayList<Path> tempClassPath = new ArrayList<Path>(classPath);
            tempClassPath.remove(path);
            tempClassPath.add(artifactPath);
            Path outputPath = path.getParent().resolve("remapped_dependency_" + count + ".jar");
            try {
                this.mapJar(path, outputPath, mappingsMojangPath, "mojang", "obfuscated", tempClassPath.toArray(new Path[0]));
            }
            catch (IOException | URISyntaxException exception) {
                throw new MojoExecutionException("Failed to remap dependency", exception);
            }
            newClassPath.add(outputPath);
            ++count;
        }
        if (Files.isDirectory(artifactPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Remapping classes to Spigot mappings");
            this.remapClasses(artifactPath, mappingsSpigotPath, "obfuscated", "spigot", newClassPath, true);
        } else {
            Path outputPath = this.getCacheDirectory().resolve("remapped_2.jar");
            this.getLog().info((CharSequence)"Remapping artifact to Spigot mappings");
            this.remapArtifact(artifactPath, outputPath, mappingsSpigotPath, "obfuscated", "spigot", newClassPath);
        }
        for (Path path : newClassPath) {
            try {
                Files.delete(path);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Unable to delete remapped dependency", (Exception)exception);
            }
        }
    }
}

