/*
 * Decompiled with CFR 0.152.
 */
package ca.bkaw.papernmsmavenplugin;

import ca.bkaw.papernmsmavenplugin.DevBundle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.lorenztiny.TinyMappingFormat;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.TinyUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.MappingFormats;
import org.cadixdev.lorenz.io.proguard.ProGuardReader;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class MojoBase
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    List<ArtifactRepository> remoteRepositories;
    @Component
    ArtifactFactory artifactFactory;
    @Component
    ArtifactInstaller artifactInstaller;
    @Component
    ArtifactResolver artifactResolver;
    @Parameter(property="devBundle")
    DevBundle devBundle;

    public Path getCacheDirectory() {
        MavenProject project = this.project.hasParent() ? this.project.getParent() : this.project;
        return project.getBasedir().toPath().resolve(".paper-nms");
    }

    public String getNmsGroupId() {
        return "paper-nms".equals(this.devBundle.id) ? "ca.bkaw" : "ca.bkaw.nms";
    }

    public void createDevBundleConfiguration() {
        if (this.devBundle == null || this.devBundle.id == null) {
            this.devBundle = DevBundle.PAPER_DEV_BUNDLE;
        }
    }

    public String getGameVersion() throws MojoFailureException {
        for (Object object : this.project.getDependencies()) {
            Dependency dependency = (Dependency)object;
            if (!this.getNmsGroupId().equals(dependency.getGroupId()) || !this.devBundle.id.equals(dependency.getArtifactId())) continue;
            String version = dependency.getVersion();
            return version.substring(0, version.indexOf(45));
        }
        throw new MojoFailureException("Unable to find the version to use.\nUnable to find the version to use. Make sure you have the following dependency in your <dependencies> tag:\n\n<dependency>\n    <groupId>" + this.getNmsGroupId() + "</groupId>\n    <artifactId>" + this.devBundle.id + "</artifactId>\n    <version>1.21.4-SNAPSHOT</version>\n    <scope>provided</scope>\n</dependency>\n\n Replacing \"1.21.4\" with the desired version.");
    }

    public void downloadFile(String url, Path path) throws MojoExecutionException {
        try {
            InputStream in = new URL(url).openStream();
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to download " + path.getFileName(), (Exception)e);
        }
    }

    public void downloadFile(String url, Path path, String sha1) throws MojoExecutionException {
        byte[] hash;
        this.downloadFile(url, path);
        MessageDigest messageDigest = this.getSHA1();
        try {
            hash = messageDigest.digest(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check hash of downloaded file " + path.getFileName(), (Exception)e);
        }
        String fileSha1 = this.toHex(hash);
        if (!sha1.equals(fileSha1)) {
            throw new MojoExecutionException("Download failed, sha1 hash of downloaded file did not match. Expected: " + sha1 + " Found: " + fileSha1 + " for file " + path.getFileName());
        }
    }

    public String toHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte value : bytes) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    private MessageDigest getSHA1() throws MojoExecutionException {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Unable to find SHA-1 MessageDigest.", (Exception)e);
        }
    }

    public void deleteRecursively(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void init() throws MojoExecutionException, MojoFailureException {
        this.createDevBundleConfiguration();
        String gameVersion = this.getGameVersion();
        Path cacheDirectory = this.getCacheDirectory();
        String extra = !"paper-nms".equals(this.devBundle.id) ? " (" + this.devBundle.id + ")" : "";
        this.getLog().info((CharSequence)("Initializing paper-nms for game version: " + gameVersion + extra));
        this.getLog().info((CharSequence)"Preparing cache folder");
        try {
            Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create .paper-nms cache folder.", (Exception)e);
        }
        Path mappingsPath = cacheDirectory.resolve("mappings_" + gameVersion + ".tiny");
        Path mappedServerPath = cacheDirectory.resolve("mapped_" + gameVersion + ".jar");
        ArrayList<String> dependencyCoordinates = new ArrayList<String>();
        this.getLog().info((CharSequence)"Downloading dev-bundle");
        Path devBundlePath = this.resolveDevBundle(gameVersion);
        if (devBundlePath != null) {
            this.getLog().info((CharSequence)"Extracting dev-bundle");
            Path paperclipPath = cacheDirectory.resolve("paperclip.jar");
            this.extractDevBundle(paperclipPath, mappingsPath, devBundlePath, dependencyCoordinates, gameVersion);
            this.getLog().info((CharSequence)"Extracting server");
            this.extractServerJar(gameVersion, cacheDirectory, mappedServerPath);
        } else if (this.devBundle == DevBundle.PAPER_DEV_BUNDLE) {
            Path mappingsMojangPath = cacheDirectory.resolve("mappings_" + gameVersion + "_mojang.tiny");
            Path mappingsSpigotPath = cacheDirectory.resolve("mappings_" + gameVersion + "_spigot.tiny");
            Path mojangMappingsPath = cacheDirectory.resolve("mojang_mappings.txt");
            this.downloadMojangMappings(mojangMappingsPath, gameVersion);
            this.getLog().info((CharSequence)"Downloading spigot mappings");
            Path spigotClassMappingsPath = cacheDirectory.resolve("spigot_class_mappings_" + gameVersion + ".csrg");
            Path spigotMemberMappingsPath = cacheDirectory.resolve("spigot_member_mappings_" + gameVersion + ".csrg");
            this.downloadSpigotMappings(spigotClassMappingsPath, spigotMemberMappingsPath, gameVersion);
            this.getLog().info((CharSequence)"Merging mappings");
            this.mergeMappings(spigotClassMappingsPath, spigotMemberMappingsPath, mojangMappingsPath, mappingsPath, mappingsMojangPath, mappingsSpigotPath);
            Path paperclipPath = cacheDirectory.resolve("paperclip.jar");
            this.downloadPaper(gameVersion, paperclipPath);
            this.getLog().info((CharSequence)"Extracting paper");
            Path paperPath = cacheDirectory.resolve("paper.jar");
            this.extractServerJar(gameVersion, cacheDirectory, paperPath);
            this.getLog().info((CharSequence)"Mapping paper jar");
            this.mapPaperJar(mappingsPath, paperPath, mappedServerPath);
        } else {
            throw new MojoFailureException("No dev bundle was found for version " + gameVersion);
        }
        this.getLog().info((CharSequence)"Installing into local maven repository");
        Path pomPath = cacheDirectory.resolve("pom.xml");
        this.installToMavenRepo(gameVersion, dependencyCoordinates, mappedServerPath, pomPath);
    }

    public List<ArtifactRepository> getDevBundleRepositories() throws MojoExecutionException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        if (this.devBundle.repository != null) {
            if (this.devBundle.repository.url == null) {
                ArtifactRepository repo = null;
                for (ArtifactRepository remoteRepository : this.remoteRepositories) {
                    if (!remoteRepository.getId().equals(this.devBundle.repository.id)) continue;
                    repo = remoteRepository;
                    break;
                }
                if (repo == null) {
                    throw new MojoExecutionException("Failed to find repository " + this.devBundle.repository.id);
                }
                repositories.add(repo);
            } else {
                repositories.add((ArtifactRepository)new MavenArtifactRepository(this.devBundle.repository.id, this.devBundle.repository.url, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy()));
            }
        }
        return repositories;
    }

    public Artifact getDevBundleArtifact(CharSequence gameVersion) {
        return this.artifactFactory.createArtifactWithClassifier(this.devBundle.artifact.groupId, this.devBundle.artifact.artifactId, this.devBundle.artifact.version.replace("${gameVersion}", gameVersion), "zip", this.devBundle.artifact.classifier);
    }

    @Nullable
    public Path resolveDevBundle(String gameVersion) throws MojoExecutionException {
        Artifact artifact = this.getDevBundleArtifact(gameVersion);
        List<ArtifactRepository> repositories = this.getDevBundleRepositories();
        try {
            this.artifactResolver.resolve(artifact, repositories, this.localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            this.getLog().info((CharSequence)("No dev bundle was found for version " + gameVersion));
            return null;
        }
        return artifact.getFile().toPath();
    }

    @Nullable
    public Path resolveGradleModuleMetadata(Artifact artifact) throws MojoExecutionException {
        Artifact metadataArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "module", artifact.getClassifier());
        List<ArtifactRepository> repositories = this.getDevBundleRepositories();
        try {
            this.artifactResolver.resolve(metadataArtifact, repositories, this.localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("No gradle module metadata for " + artifact.getArtifactId()));
            return null;
        }
        if (metadataArtifact.getFile() == null) {
            this.getLog().warn((CharSequence)("No gradle module metadata (file is null) for " + artifact.getArtifactId()));
            return null;
        }
        return metadataArtifact.getFile().toPath();
    }

    public void extractDevBundle(Path paperclipPath, Path mappingsPath, Path devBundlePath, List<String> dependencyCoordinates, String gameVersion) throws MojoExecutionException, MojoFailureException {
        try {
            JSONObject config;
            JSONObject buildData;
            URI uri = new URI("jar:" + devBundlePath.toUri());
            FileSystem devBundle = FileSystems.newFileSystem(uri, new HashMap());
            int dataVersion = Integer.parseInt(String.join((CharSequence)"", Files.readAllLines(devBundle.getPath("data-version.txt", new String[0]))).trim());
            if (dataVersion != 3 && dataVersion != 2 && dataVersion != 5 && dataVersion != 6) {
                this.getLog().warn((CharSequence)("Unsupported dev-bundle version. Found data version " + dataVersion + " but only 2, 3, 5 and 6 are supported. Things may not work properly. If problems occur, try updating paper-nms-maven-plugin to a newer version if that exists. If this is a problem on the latest version of paper-nms-maven-plugin, please open an issue on GitHub."));
            }
            JSONObject jSONObject = buildData = (config = new JSONObject(new JSONTokener(Files.newInputStream(devBundle.getPath("config.json", new String[0]), new OpenOption[0])))).has("buildData") ? config.getJSONObject("buildData") : null;
            if (dataVersion >= 3 && dataVersion < 6 && buildData != null) {
                for (Object runtimeDependency : buildData.getJSONArray("runtimeDependencies")) {
                    dependencyCoordinates.add(String.valueOf(runtimeDependency));
                }
                dependencyCoordinates.add(config.getString("apiCoordinates"));
                if (config.has("mojangApiCoordinates")) {
                    dependencyCoordinates.add(config.getString("mojangApiCoordinates"));
                }
            }
            if (dataVersion >= 6) {
                this.getLog().info((CharSequence)"Finding dependencies");
                Artifact devBundleArtifact = this.getDevBundleArtifact(gameVersion);
                Path metadata = this.resolveGradleModuleMetadata(devBundleArtifact);
                dependencyCoordinates.addAll(this.getCompileDependenciesFromMetadata(metadata));
                JSONObject mache = config.getJSONObject("mache");
                JSONArray macheCoordinatesList = mache.getJSONArray("coordinates");
                for (int i = 0; i < macheCoordinatesList.length(); ++i) {
                    String macheCoordinates = macheCoordinatesList.getString(i);
                    dependencyCoordinates.remove(macheCoordinates);
                    String[] macheCoordinateParts = macheCoordinates.split(":");
                    String groupId = macheCoordinateParts[0];
                    String artifactId = macheCoordinateParts[1];
                    String version = macheCoordinateParts[2];
                    Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, null, "jar");
                    Path macheMetadata = this.resolveGradleModuleMetadata(artifact);
                    dependencyCoordinates.addAll(this.getCompileDependenciesFromMetadata(macheMetadata));
                }
            }
            if (dataVersion >= 6 || buildData == null) {
                buildData = config;
            }
            Path bundleMappingsPath = devBundle.getPath(buildData.getString("reobfMappingsFile"), new String[0]);
            Path bundlePaperclipPath = devBundle.getPath(buildData.getString("mojangMappedPaperclipFile"), new String[0]);
            Files.copy(bundleMappingsPath, mappingsPath, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(bundlePaperclipPath, paperclipPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | URISyntaxException e) {
            throw new MojoExecutionException("Failed to extract dev-bundle files.", e);
        }
    }

    public List<String> getCompileDependenciesFromMetadata(@Nullable Path metadataPath) throws IOException {
        if (metadataPath == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> dependencyCoordinates = new ArrayList<String>();
        JSONObject module = new JSONObject(new JSONTokener(Files.newInputStream(metadataPath, new OpenOption[0])));
        String formatVersion = module.getString("formatVersion");
        if (!"1.1".equals(formatVersion)) {
            this.getLog().warn((CharSequence)("Unsupported Gradle module metadata format version. Found format version " + formatVersion + " but only 1.1 is supported. Things may not work properly. If problems occur, try updating paper-nms-maven-plugin to a newer version if that exists. If this is a problem on the latest version of paper-nms-maven-plugin, please open an issue on GitHub."));
        }
        JSONArray variants = module.getJSONArray("variants");
        boolean found = false;
        for (int i = 0; i < variants.length(); ++i) {
            JSONObject variant = variants.getJSONObject(i);
            JSONObject attributes = variant.getJSONObject("attributes");
            if (attributes == null || !attributes.has("org.gradle.usage") || !"java-api".equals(attributes.getString("org.gradle.usage"))) continue;
            found = true;
            JSONArray dependencies = variant.getJSONArray("dependencies");
            for (int j = 0; j < dependencies.length(); ++j) {
                JSONObject dependency = dependencies.getJSONObject(j);
                String group = dependency.getString("group");
                String artifactId = dependency.getString("module");
                JSONObject versionObject = dependency.getJSONObject("version");
                if (!versionObject.has("requires")) continue;
                String version = versionObject.getString("requires");
                dependencyCoordinates.add(group + ':' + artifactId + ':' + version);
            }
        }
        if (!found) {
            this.getLog().warn((CharSequence)"No serverCompileClasspath found in Gradle module metadata.");
        }
        return dependencyCoordinates;
    }

    public void downloadMojangMappings(Path mojangMappingsPath, String gameVersion) throws MojoFailureException, MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Downloading version manifest");
            InputStream versionManifest = new URL("https://launchermeta.mojang.com/mc/game/version_manifest_v2.json").openStream();
            JSONObject versionManifestJson = new JSONObject(new JSONTokener(versionManifest));
            JSONArray versions = versionManifestJson.getJSONArray("versions");
            String versionInfoUrl = null;
            for (int i = 0; i < versions.length(); ++i) {
                JSONObject versionJson = versions.getJSONObject(i);
                String id = versionJson.getString("id");
                if (!gameVersion.equals(id)) continue;
                versionInfoUrl = versionJson.getString("url");
                break;
            }
            versionManifest.close();
            if (versionInfoUrl == null) {
                throw new MojoFailureException("The version \"" + gameVersion + "\" was not found.");
            }
            this.getLog().info((CharSequence)"Downloading version info");
            InputStream versionInfo = new URL(versionInfoUrl).openStream();
            JSONObject versionInfoJson = new JSONObject(new JSONTokener(versionInfo));
            JSONObject downloads = versionInfoJson.getJSONObject("downloads");
            JSONObject mappings = downloads.getJSONObject("server_mappings");
            String mappingsUrl = mappings.getString("url");
            String mappingsSha1 = mappings.getString("sha1");
            versionInfo.close();
            this.getLog().info((CharSequence)"Downloading mojang mappings");
            this.downloadFile(mappingsUrl, mojangMappingsPath, mappingsSha1);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to get the mojang mappings.", (Exception)e);
        }
    }

    public void downloadSpigotMappings(Path spigotClassMappingsPath, Path spigotMemberMappingsPath, String gameVersion) throws MojoExecutionException {
        InputStream inputStream;
        this.getLog().info((CharSequence)"Downloading spigot version info");
        try {
            inputStream = new URL("https://hub.spigotmc.org/versions/" + gameVersion + ".json").openStream();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to download spigot version info");
        }
        JSONObject json = new JSONObject(new JSONTokener(inputStream));
        JSONObject refs = json.getJSONObject("refs");
        String ref = refs.getString("BuildData");
        String classMappingsUrl = "https://hub.spigotmc.org/stash/projects/SPIGOT/repos/builddata/raw/mappings/bukkit-" + gameVersion + "-cl.csrg?at=" + ref;
        String memberMappingsUrl = "https://hub.spigotmc.org/stash/projects/SPIGOT/repos/builddata/raw/mappings/bukkit-" + gameVersion + "-members.csrg?at=" + ref;
        this.downloadFile(classMappingsUrl, spigotClassMappingsPath);
        this.downloadFile(memberMappingsUrl, spigotMemberMappingsPath);
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(spigotMemberMappingsPath);
            String s = bufferedReader.readLine();
            bufferedReader.close();
            if (s.contains("html")) {
                Files.delete(spigotMemberMappingsPath);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to validate spigot member mappings", (Exception)e);
        }
    }

    public void mergeMappings(Path spigotClassMappingsPath, Path spigotMemberMappingsPath, Path mojangMappingsPath, Path outputPath, Path outputMojangPath, Path outputSpigotPath) throws MojoExecutionException {
        MappingSet mojangMappings;
        MappingSet spigotMappings;
        MappingSet spigotClassMappings;
        try {
            spigotClassMappings = MappingFormats.CSRG.read(spigotClassMappingsPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read spigot class mappings", (Exception)e);
        }
        if (Files.exists(spigotMemberMappingsPath, new LinkOption[0])) {
            MappingSet memberMappings;
            try {
                memberMappings = MappingFormats.CSRG.read(spigotMemberMappingsPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read spigot member mappings", (Exception)e);
            }
            spigotMappings = spigotClassMappings.merge(memberMappings);
        } else {
            spigotMappings = spigotClassMappings;
        }
        try {
            mojangMappings = new ProGuardReader((Reader)Files.newBufferedReader(mojangMappingsPath)).read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read mojang mappings", (Exception)e);
        }
        MappingSet mappings = spigotMappings.reverse().merge(mojangMappings.reverse());
        this.fixMappings(mappings);
        try {
            TinyMappingFormat.TINY_2.write(mappings, outputPath, "spigot", "mojang");
            TinyMappingFormat.TINY_2.write(mojangMappings, outputMojangPath, "mojang", "obfuscated");
            TinyMappingFormat.TINY_2.write(spigotMappings, outputSpigotPath, "obfuscated", "spigot");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write merged mappings", (Exception)e);
        }
        this.getLog().info((CharSequence)"Cleaning up mappings");
        try {
            Files.delete(mojangMappingsPath);
            Files.delete(spigotClassMappingsPath);
            Files.deleteIfExists(spigotMemberMappingsPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean up mappings");
        }
    }

    public void fixMappings(MappingSet mappings) {
        mappings.getClassMapping("net/minecraft/world/level/storage/loot/entries/LootEntryAbstract$Serializer").ifPresent(classMapping -> classMapping.getMethodMapping("serializeType", "(Lcom/google/gson/JsonObject;Lnet/minecraft/world/level/storage/loot/entries/LootEntryAbstract;Lcom/google/gson/JsonSerializationContext;)V").ifPresent(methodMapping -> methodMapping.setDeobfuscatedName("mappingfix")));
        mappings.getClassMapping("net/minecraft/world/item/trading/IMerchant").ifPresent(classMapping -> classMapping.getMethodMapping("getWorld", "()Lnet/minecraft/world/level/World;").ifPresent(methodMapping -> methodMapping.setDeobfuscatedName("getCommandSenderWorld")));
    }

    public void downloadPaper(String gameVersion, Path paperclipPath) throws MojoExecutionException {
        InputStream inputStream;
        this.getLog().info((CharSequence)"Fetching latest paper build");
        try {
            inputStream = new URL("https://api.papermc.io/v2/projects/paper/versions/" + gameVersion).openStream();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to download paper builds", (Exception)e);
        }
        JSONObject json = new JSONObject(new JSONTokener(inputStream));
        JSONArray builds = json.getJSONArray("builds");
        int highestBuild = -1;
        for (int i = 0; i < builds.length(); ++i) {
            int build = builds.getInt(i);
            if (build <= highestBuild) continue;
            highestBuild = build;
        }
        this.getLog().info((CharSequence)("The latest paper build for " + gameVersion + " is " + highestBuild));
        this.getLog().info((CharSequence)"Downloading paper");
        this.downloadFile("https://api.papermc.io/v2/projects/paper/versions/" + gameVersion + "/builds/" + highestBuild + "/downloads/paper-" + gameVersion + "-" + highestBuild + ".jar", paperclipPath);
    }

    public void extractServerJar(String gameVersion, Path cacheDirectory, Path serverPath) throws MojoExecutionException, MojoFailureException {
        int exitCode;
        Process process;
        String javaExecutable;
        Path bin = Paths.get(System.getProperty("java.home"), "bin");
        Path javaPath = bin.resolve("java");
        if (!Files.exists(javaPath, new LinkOption[0])) {
            javaPath = bin.resolve("java.exe");
        }
        if (Files.exists(javaPath, new LinkOption[0])) {
            javaExecutable = javaPath.toAbsolutePath().toString();
        } else {
            this.getLog().warn((CharSequence)"Unable to find the java executable, will use a generic \"java\".");
            javaExecutable = "java";
        }
        ProcessBuilder processBuilder = new ProcessBuilder(javaExecutable, "-Dpaperclip.patchonly=true", "-jar", "paperclip.jar");
        processBuilder.directory(cacheDirectory.toFile());
        try {
            process = processBuilder.start();
            exitCode = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Failed to execute paperclip jar.", e);
        }
        if (exitCode != 0) {
            try {
                String line;
                BufferedReader buf = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = buf.readLine()) != null) {
                    this.getLog().info((CharSequence)("[paperclip] " + line));
                    if (!line.contains("Java")) continue;
                    Matcher matcher = Pattern.compile("Java (?<number>\\d+)").matcher(line);
                    if (matcher.find()) {
                        String number = matcher.group("number");
                        throw new MojoFailureException("Failed to extract the server jar due to an outdated Java version.\nPaperclip failed due to an outdated Java version.\n\nTry changing the project's java version by for example adding the following to your pom.xml.\n\n<properties>\n  <maven.compiler.source>" + number + "</maven.compiler.source>\n  <maven.compiler.target>" + number + "</maven.compiler.target>\n</properties>\n\nOr make sure the project is running Java " + number + " by going to Project Structure.\n\nThis is only required for paper-nms:init, the java version can be downgraded again afterwards if desired.");
                    }
                    throw new MojoExecutionException("Paperclip failed due to an outdated Java version.\nPaperclip failed due to an outdated Java version.\nSee the maven log for a more detailed error output.\nPaperclip error log: " + line);
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Failed to fetch detailed error information from paperclip.", (Throwable)e);
            }
            throw new MojoExecutionException("Paperclip exited with exit code: " + exitCode);
        }
        String versionsPath = null;
        try (FileSystem paperclipJar = FileSystems.newFileSystem(URI.create("jar:" + cacheDirectory.resolve("paperclip.jar").toUri()), new HashMap());){
            Path versionsListPath = paperclipJar.getPath("META-INF", "versions.list");
            if (Files.exists(versionsListPath, new LinkOption[0])) {
                List<String> versions = Files.readAllLines(versionsListPath);
                for (String versionLine : versions) {
                    versionsPath = versionLine.split("\t")[2];
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get path of extracted server in the versions folder.", (Exception)e);
        }
        Path extractedServerPath = null;
        if (versionsPath != null && !Files.exists(extractedServerPath = cacheDirectory.resolve("versions").resolve(versionsPath), new LinkOption[0])) {
            extractedServerPath = null;
        }
        if (extractedServerPath == null && !Files.exists(extractedServerPath = cacheDirectory.resolve("cache").resolve("patched_" + gameVersion + ".jar"), new LinkOption[0])) {
            throw new MojoExecutionException("Unable to find the patched server jar");
        }
        try {
            Files.move(extractedServerPath, serverPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to move extracted server jar into .paper-nms folder", (Exception)e);
        }
        this.getLog().info((CharSequence)"Extracted server jar");
        this.getLog().info((CharSequence)"Cleaning up paperclip");
        try {
            Files.delete(cacheDirectory.resolve("paperclip.jar"));
            this.deleteRecursively(cacheDirectory.resolve("cache"));
            this.deleteRecursively(cacheDirectory.resolve("versions"));
            this.deleteRecursively(cacheDirectory.resolve("libraries"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean up paperclip");
        }
    }

    public void mapJar(Path in, Path out, Path mappingsPath, String mappingFrom, String mappingTo, Path ... classPath) throws IOException, URISyntaxException {
        IMappingProvider mappings = TinyUtils.createTinyMappingProvider((Path)mappingsPath, (String)mappingFrom, (String)mappingTo);
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappings).ignoreConflicts(true).build();
        remapper.readClassPath(classPath);
        remapper.readInputs(new Path[]{in});
        Files.deleteIfExists(out);
        URI uri = new URI("jar:" + out.toUri());
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("create", true);
        FileSystem outputFileSystem = FileSystems.newFileSystem(uri, env);
        JarFile inputJar = new JarFile(in.toFile());
        int classCount = 0;
        Enumeration<JarEntry> iter = inputJar.entries();
        while (iter.hasMoreElements()) {
            JarEntry jarEntry = iter.nextElement();
            if (jarEntry.getName().endsWith(".class")) {
                ++classCount;
                continue;
            }
            if (jarEntry.isDirectory()) continue;
            InputStream stream = inputJar.getInputStream(jarEntry);
            Path path = outputFileSystem.getPath(jarEntry.getName(), new String[0]);
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(stream, path, new CopyOption[0]);
            stream.close();
        }
        remapper.apply((name, bytes) -> {
            Path path = outputFileSystem.getPath(name + ".class", new String[0]);
            try {
                Path parent = path.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write class " + name + " to jar", e);
            }
        });
        remapper.finish();
        inputJar.close();
        outputFileSystem.close();
    }

    public void mapPaperJar(Path mappingsPath, Path paperPath, Path mappedPaperPath) throws MojoExecutionException {
        try {
            this.mapJar(paperPath, mappedPaperPath, mappingsPath, "spigot", "mojang", new Path[0]);
        }
        catch (IOException | URISyntaxException e) {
            throw new MojoExecutionException("Failed to map paper jar", e);
        }
        catch (RuntimeException e) {
            if ("Unfixable conflicts".equals(e.getMessage())) {
                throw new MojoExecutionException(e.getMessage() + "\nUnable to map the paper jar due to unfixable mapping conflicts. This is a known issue for non 1.18 versions, sorry!\nSee https://github.com/Alvinn8/paper-nms-maven-plugin/issues/1", (Exception)e);
            }
            throw e;
        }
        this.getLog().info((CharSequence)"Cleaning up paper jar");
        try {
            Files.delete(paperPath);
            Files.delete(mappingsPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete paper jar", (Exception)e);
        }
    }

    public void installToMavenRepo(String gameVersion, List<String> dependencyCoordinates, Path mappedServerPath, Path pomPath) throws MojoExecutionException {
        StringBuilder pom = new StringBuilder().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n").append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n").append("  <modelVersion>4.0.0</modelVersion>\n").append("  <groupId>").append(this.getNmsGroupId()).append("</groupId>\n").append("  <artifactId>").append(this.devBundle.id).append("</artifactId>\n").append("  <version>").append(gameVersion).append("-SNAPSHOT</version>\n");
        if (!dependencyCoordinates.isEmpty()) {
            pom.append("\n");
            pom.append("<repositories>\n");
            pom.append("<repository>\n");
            pom.append("    <id>papermc</id>\n");
            pom.append("    <url>https://repo.papermc.io/repository/maven-public/</url>\n");
            pom.append("</repository>\n");
            pom.append("<repository>\n");
            pom.append("    <id>minecraft-libraries</id>\n");
            pom.append("    <name>Minecraft Libraries</name>\n");
            pom.append("    <url>https://libraries.minecraft.net</url>\n");
            pom.append("</repository>\n");
            pom.append("<repository>\n");
            pom.append("    <id>fabric</id>\n");
            pom.append("    <url>https://maven.fabricmc.net</url>\n");
            pom.append("</repository>\n");
            pom.append("</repositories>\n");
            pom.append("\n");
            pom.append("  <dependencies>\n");
            for (String dependency : dependencyCoordinates) {
                String[] coordinates = dependency.split(":");
                String groupId = coordinates[0];
                String artifactId = coordinates[1];
                String version = coordinates[2];
                pom.append("<dependency>\n");
                pom.append("    <groupId>").append(groupId).append("</groupId>\n");
                pom.append("    <artifactId>").append(artifactId).append("</artifactId>\n");
                pom.append("    <version>").append(version).append("</version>\n");
                pom.append("</dependency>\n");
            }
            pom.append("  </dependencies>\n");
        }
        pom.append("</project>\n");
        try {
            Files.write(pomPath, pom.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write pom.xml", (Exception)e);
        }
        try {
            this.installViaArtifactInstaller(mappedServerPath, pomPath, gameVersion);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Failed to install mapped server jar to local repository.", (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)"Installed into local repository");
        this.getLog().info((CharSequence)"Cleaning up");
        try {
            Files.delete(mappedServerPath);
            Files.deleteIfExists(pomPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean up", (Exception)e);
        }
    }

    private void installViaArtifactInstaller(Path artifactPath, Path pomPath, String gameVersion) throws ArtifactInstallationException {
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.getNmsGroupId(), this.devBundle.id, gameVersion + "-SNAPSHOT", "jar", null);
        ProjectArtifactMetadata pomMetadata = new ProjectArtifactMetadata(artifact, pomPath.toFile());
        artifact.addMetadata((ArtifactMetadata)pomMetadata);
        this.artifactInstaller.install(artifactPath.toFile(), artifact, this.localRepository);
    }

    @Deprecated
    private void installViaCmd(Path artifactPath, Path pomPath) throws ArtifactInstallationException, IOException, InterruptedException {
        String mvn = System.getProperty("os.name").toLowerCase().contains("windows") ? "mvn.cmd" : "mvn";
        int exitCode = new ProcessBuilder(mvn, "-version").start().waitFor();
        if (exitCode != 0) {
            throw new ArtifactInstallationException("Maven not found on path. Exited with exit code: " + exitCode);
        }
        int exitCode2 = new ProcessBuilder(mvn, "install:install-file", "-Dfile=" + artifactPath, "-DpomFile=" + pomPath).start().waitFor();
        if (exitCode2 != 0) {
            throw new ArtifactInstallationException("Failed to install. Maven exited with exit code: " + exitCode);
        }
    }

    @Deprecated
    private void installViaCopy(Path artifactPath, Path pomPath, String gameVersion) throws ArtifactInstallationException {
        Path basePath = Paths.get(this.localRepository.getBasedir(), "ca", "bkaw", "paper-nms", gameVersion + "-SNAPSHOT");
        String artifactName = "paper-nms-" + gameVersion + "-SNAPSHOT";
        Path repoArtifactPath = basePath.resolve(artifactName + ".jar");
        Path repoPomPath = basePath.resolve(artifactName + ".pom");
        try {
            Files.copy(artifactPath, repoArtifactPath, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(pomPath, repoPomPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ArtifactInstallationException("Failed to copy files to local repository");
        }
    }
}

